/*
 * Decompiled with CFR 0.152.
 */
package jemu.ui.paint;

import com.jhlabs.image.ContrastFilter;
import com.jhlabs.image.GainFilter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.HashSet;
import javax.imageio.ImageIO;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jemu.settings.Settings;
import jemu.system.cpc.CPC;
import jemu.system.cpc.DOSHandler;
import jemu.system.cpc.GateArray;
import jemu.ui.cpcgamescd.CPCFileSystem;
import jemu.ui.paint.PaintCanvas;
import jemu.util.ass.EditorPanel;

public class MODEXPaint
extends JFrame {
    BufferedImage imageA;
    BufferedImage imageB;
    int imgwidth = 320;
    int imgheight = 200;
    int[] palette = new int[32];
    PaintCanvas can = new PaintCanvas();
    int PaletteAddress = 34304;
    int[] GAPalette = new int[16];
    int[] mode1Palette = new int[4];
    int[] newPalette = new int[16];
    int[] newInks = new int[16];
    int[] pimperial = new int[16];
    int[][] presets = new int[9][];
    BufferedImage Source;
    BufferedImage FormattedSource;
    GainFilter gainfilter = new GainFilter();
    ContrastFilter contrastfilter = new ContrastFilter();
    float[] Gain = new float[]{-1.0f, -0.99f, -0.98f, -0.97f, -0.96f, -0.95f, -0.94f, -0.93f, -0.92f, -0.91f, -0.9f, -0.89f, -0.88f, -0.87f, -0.86f, -0.85f, -0.84f, -0.83f, -0.82f, -0.81f, -0.8f, -0.79f, -0.78f, -0.77f, -0.76f, -0.75f, -0.74f, -0.73f, -0.72f, -0.71f, -0.7f, -0.69f, -0.68f, -0.67f, -0.66f, -0.65f, -0.64f, -0.63f, -0.62f, -0.61f, -0.6f, -0.59f, -0.58f, -0.57f, -0.56f, -0.55f, -0.54f, -0.53f, -0.52f, -0.51f, -0.5f, -0.49f, -0.48f, -0.47f, -0.46f, -0.45f, -0.44f, -0.43f, -0.42f, -0.41f, -0.4f, -0.39f, -0.38f, -0.37f, -0.36f, -0.35f, -0.34f, -0.33f, -0.32f, -0.31f, -0.3f, -0.29f, -0.28f, -0.27f, -0.26f, -0.25f, -0.24f, -0.23f, -0.22f, -0.21f, -0.2f, -0.19f, -0.18f, -0.17f, -0.16f, -0.15f, -0.14f, -0.13f, -0.12f, -0.11f, -0.1f, -0.09f, -0.08f, -0.07f, -0.06f, -0.05f, -0.04f, -0.03f, -0.02f, -0.01f, 0.0f, 0.01f, 0.02f, 0.03f, 0.04f, 0.05f, 0.06f, 0.07f, 0.08f, 0.09f, 0.1f, 0.11f, 0.12f, 0.13f, 0.14f, 0.15f, 0.16f, 0.17f, 0.18f, 0.19f, 0.2f, 0.21f, 0.22f, 0.23f, 0.24f, 0.25f, 0.26f, 0.27f, 0.28f, 0.29f, 0.3f, 0.31f, 0.32f, 0.33f, 0.34f, 0.35f, 0.36f, 0.37f, 0.38f, 0.39f, 0.4f, 0.41f, 0.42f, 0.43f, 0.44f, 0.45f, 0.46f, 0.47f, 0.48f, 0.49f, 0.5f, 0.51f, 0.52f, 0.53f, 0.54f, 0.55f, 0.56f, 0.57f, 0.58f, 0.59f, 0.6f, 0.61f, 0.62f, 0.63f, 0.64f, 0.65f, 0.66f, 0.67f, 0.68f, 0.69f, 0.7f, 0.71f, 0.72f, 0.73f, 0.74f, 0.75f, 0.76f, 0.77f, 0.78f, 0.79f, 0.8f, 0.81f, 0.82f, 0.83f, 0.84f, 0.85f, 0.86f, 0.87f, 0.88f, 0.89f, 0.9f, 0.91f, 0.92f, 0.93f, 0.94f, 0.95f, 0.96f, 0.97f, 0.98f, 0.99f, 1.0f};
    String fpath;
    String ffile;
    BufferedImage buffer;
    EditorPanel asm = new EditorPanel(null, 0);
    byte[] code;
    DOSHandler handler = new DOSHandler();
    FileDialog dialog;
    boolean overscan;
    FileDialog create;
    FileDialog open;
    CPCFileSystem system;
    private JCheckBox alternative;
    private JSlider bright;
    private ButtonGroup buttonGroup1;
    private JRadioButton c7d0;
    private JSlider contrast;
    private JCheckBox direction;
    private JTextField diskname;
    private JRadioButton free;
    private JLabel free1;
    private JRadioButton full;
    private JSlider gain;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JButton jButton9;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JList<String> jList1;
    private JScrollPane jScrollPane4;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;
    private JRadioButton partial;
    private JComboBox<String> preselect;
    private JTextField rasname;
    private JCheckBox rendermode;
    private JRadioButton stabilize;

    public MODEXPaint() {
        this.initComponents();
        this.assemble();
        this.presets[0] = new int[]{0, 6, 13, 25, 16, 3, 4, 2, 1, 14, 23, 9, 21, 26, 12, 15};
        this.presets[1] = new int[]{0, 15, 13, 25, 6, 16, 25, 26, 1, 2, 18, 9, 12, 3, 7, 11};
        this.presets[2] = new int[]{0, 3, 15, 26, 25, 16, 6, 9, 21, 23, 14, 11, 2, 1, 13, 4};
        this.presets[3] = new int[]{0, 16, 13, 26, 6, 3, 4, 2, 1, 11, 23, 9, 21, 25, 12, 15};
        this.presets[4] = new int[]{0, 6, 2, 25, 16, 3, 4, 18, 1, 11, 23, 9, 21, 26, 12, 15};
        this.presets[5] = new int[]{0, 1, 3, 26, 16, 6, 4, 18, 1, 11, 23, 2, 21, 25, 12, 15};
        this.presets[6] = new int[]{0, 1, 3, 26, 16, 6, 4, 18, 1, 11, 23, 2, 21, 25, 12, 15};
    }

    public static void main(String[] args) {
        String path = "C:\\JavaCPC\\rasterslide\\";
        int xpos = 0;
        int ypos = 0;
        String[] files = new File(path).list();
        try {
            BufferedImage result = new BufferedImage(1536, 1088, 1);
            for (int i = 0; i < files.length; ++i) {
                File a = new File(path + files[i]);
                if (!a.isFile()) continue;
                BufferedImage in = ImageIO.read(a);
                result.createGraphics().drawImage(in, xpos, ypos, 384, 272, null);
                if ((xpos += 384) < 1536) continue;
                xpos = 0;
                ypos += 272;
            }
            File b = new File(path + "result\\");
            b.mkdir();
            b = new File(path + "result\\result.png");
            ImageIO.write((RenderedImage)result, "PNG", b);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initComponents() {
        this.jTextArea1 = new JTextArea();
        this.jTextArea2 = new JTextArea();
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.bright = new JSlider();
        this.contrast = new JSlider();
        this.gain = new JSlider();
        this.jLabel3 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.alternative = new JCheckBox();
        this.jCheckBox1 = new JCheckBox();
        this.free = new JRadioButton();
        this.partial = new JRadioButton();
        this.full = new JRadioButton();
        this.jButton3 = new JButton();
        this.stabilize = new JRadioButton();
        this.direction = new JCheckBox();
        this.preselect = new JComboBox();
        this.rendermode = new JCheckBox();
        this.jLabel8 = new JLabel();
        this.diskname = new JTextField();
        this.jButton6 = new JButton();
        this.jButton8 = new JButton();
        this.jScrollPane4 = new JScrollPane();
        this.jList1 = new JList();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.rasname = new JTextField();
        this.jButton7 = new JButton();
        this.free1 = new JLabel();
        this.jLabel11 = new JLabel();
        this.c7d0 = new JRadioButton();
        this.jButton4 = new JButton();
        this.jButton5 = new JButton();
        this.jButton9 = new JButton();
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText("\t\tORG\t\t#8600\n\t\trun\t\t#8600\n\n\t\t;\t\tENT $\n\t\t;\n\t\t;\n\t\t;\t\tcopyright CMP / IMPACT   In 2016\n\t\t;\t\tMulti Mode by line\n\t\t;\t\tfor my friend DevilMarkus\n\t\t;\t\tcolours use system values.\n\n\t\tLD\t\tHL, #D7D1\nBCL:\t\tLD      B,  (HL)\n\t\tLD\t\tC,  B\n\t\tPUSH\t\tAF\n\t\tPUSH\t\tHL\n\t\tCALL\t\t#BC32\n\t\tPOP\t\tHL\n\t\tPOP\t\tAF\n\t\tINC\t\tHL\n\t\tINC\t\tA\n\t\tCP\t\t#10\n\t\tJR\t\tNZ,BCL\n\t\tcall\t\t&BD19\n\t\tcall\t\t&BD19\n\t\tcall\t\t&BD19\n\t\tcall\t\t&BD19\n\n\t\tDI\n\t\tLD\t\thl,(#38)\n\t\tLD\t\t(INTER),hl\n\t\tLD\t\thl,#c9fb\n\t\tLD\t\t(#38),hl\n\t\t;\n\t\tEI\n\n\n\n\nmain0\n\n\t\tLD\t\tb,#F5\nsync0\t\tIN a,(c)\n\t\tRRA\n\t\tjr\t\tnc,sync0\n\n\n\t\t;\n\n\t\tld\t\tb,70         ;3\nvisu\t\tDS 60        ; on attents 32  lignes pou\n\t\tDJNZ\t\tvisu       ;\n\n\n\t\t;\n\n\n\t\tds\t\t34,0 ;54\n\n\t\tcall\t\tXmode\n\n\t\t;test\t\tspace\nspace\n\t\tLD\t\tbc,#F40E\n\t\tOUT\t\t(c),c\n\t\tLD\t\tbc,#F6C0\n\t\tOUT\t\t(c),c\n\t\tXOR\t\ta\n\t\tOUT\t\t(c),a\n\t\tLD\t\tbc,#F792\n\t\tOUT\t\t(c),c\n\t\tDEC\t\tb\n\n\t\tLD\t\tc,#46-1       ;CTRL\n\t\tOUT\t\t(c),c\n\t\tLD\t\tb,#F4\n\t\tIN\t\ta,(c)\n\t\tLD\t\tbc,#F782\n\t\tOUT\t\t(c),c\n\t\tDEC\t\tb\n\t\tLD\t\tc,#00\n\t\tOUT\t\t(c),c\n\t\tAND\t\t#80\n\t\tJP\t\tnz,main0\n\n\n\t\t;\t\tretour au systeme et restaure interruption z80\nsys\n\t\t;\n\n\n\t\tLD\t\thl,(INTER)\n\t\tLD\t\t(#38),HL\n\t\tEI\n\t\t;\n\t\tRET\nINTER\t\tDW 0\n\t\t;\n\n\n\nXmode\n\n\t\tld\t\thl,tableXmode\n\t\tld\t\tb,200\n\nloopmode\n\t\tpush\t\tbc\n\n\t\tld\t\ta,(hl)\n\t\tld\t\tb,#7F\n\t\tld\t\tc,a\n\t\tout\t\t(c),c\n\n\t\tds\t\t42,0\n\t\tinc\t\thl\n\n\t\tpop\t\tbc\n\t\tdec\t\tb\n\t\tjp\t\tnz,loopmode\n\t\tret\n\ntableXmode\n\n\t\t;;MODES:\t\t9C=0 9D=1 9E=2\n\t\trepeat\t\t800\n\t\tdb\t\t#9C\n\t\tdb\t\t#9D\n\nrend\n");
        this.jTextArea2.setColumns(20);
        this.jTextArea2.setRows(5);
        this.jTextArea2.setText("ORG #8600\nrun &8600\n\n; ENT $\n;\n; \n; copyriht CMP / IMPACT   In 2016\n; Multi Mode by line\n; for my friend DevilMarkus\n; colours use system values.\n\n\ncall overscan\n\n DI \n LD hl,(#38)\n LD (INTER),hl\n LD hl,#c9fb\n LD (#38),hl\n; \nEI\n\n;call pen change the inks \n\t\tLD\t\tHL, #801\nBCL:\t\tLD      B,  (HL)\n\t\tLD\t\tC,  B\n\t\tPUSH\t\tAF\n\t\tPUSH\t\tHL\n\t\tCALL\t\t#BC32\n\t\tPOP\t\tHL\n\t\tPOP\t\tAF\n\t\tINC\t\tHL\n\t\tINC\t\tA\n\t\tCP\t\t#10\n\t\tJR\t\tNZ,BCL\n\t\tcall\t\t&BD19\n\t\tcall\t\t&BD19\n\t\tcall\t\t&BD19\n\t\tcall\t\t&BD19\n\n;;call Fill\n\n\n\nmain0   \n \n\tLD b,#F5\nsync0 \tIN a,(c)\n\t RRA \n\t jr nc,sync0\n\n\n;        \n\nld b,32         ;3\nvisu \nDS 60        ; on attents 32  lignes pou\n DJNZ visu       ;\n\n call Xmode\n\n \n\n\n\n;test space\nspace\n LD bc,#F40E\n OUT (c),c\n LD bc,#F6C0\n OUT (c),c\n XOR a\n OUT (c),a\n LD bc,#F792\n OUT (c),c\n DEC b\n\n LD c,#46-1       ;CTRL\n OUT (c),c\n LD b,#F4\n IN a,(c)\n LD bc,#F782\n OUT (c),c\n DEC b\n LD c,#00\n OUT (c),c\n AND #80 \n JP nz,main0\n       \n\n; retour au systeme et restaure interruption z80\nsys\n;\n \n\n LD hl,(INTER)\n LD (#38),HL\n EI \n;\n RET \nINTER DW 0\n;\n\n\n\nXmode \n\n      ld hl,tableXmode\n      ld b,200   ;egal valeur #30 en hex de demoniak\n\nloopmode \n       push bc\n    \n       ld a,(hl)\n       ld b,#7F\n       ld c,a\n       out (c),c\n      \n       ds 42,0\n       inc hl\n\n       pop bc\n       dec b\n       jp nz,loopmode\n       \n      ld b,72   ;egal valeur #30 en hex de demoniak\n\nloopmode2 \n       push bc\n    \n       ld a,(hl)\n       ld b,#7F\n       ld c,a\n       out (c),c\n      \n       ds 42,0\n       inc hl\n\n       pop bc\n       dec b\n       jp nz,loopmode2\n       ret\n\ntableXmode \n  \nrepeat 136\nDB &9D\nDB &9C\nrend\n\n; 8C=0 8D=1 8E=2\n\n\n;;;;;;;;;;;;;\n;;;;;;;;;;;;;;;;;;;;;;;;;;;\n\n \noverscan\n\n\t ld bc,#bc01\n\tout (c),c\n\tld bc,#bd30\n\tout (c),c\n\n\t ld bc,#bc02\n\tout (c),c\n\tld bc,#bd32\n\tout (c),c\n\n\t ld bc,#bc06\n\tout (c),c\n\tld bc,#bd23\n\tout (c),c\n\n\t ld bc,#bc07\n\tout (c),c\n\tld bc,#bd23\n\tout (c),c\n\n \t ld bc,#bc0c\n\tout (c),c\n\tld bc,#bd0d   ;0D pour demoniak  3D pour CMP\n\tout (c),c\n\n\t ld bc,#bc0d\n\tout (c),c\n\tld bc,#bd00\n\tout (c),c\n\n         ret\n");
        this.jLabel1.setBackground(new Color(0, 0, 0));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setHorizontalTextPosition(0);
        this.jLabel1.setOpaque(true);
        this.jLabel1.setPreferredSize(new Dimension(768, 544));
        this.jButton1.setText("Import");
        this.jButton1.setFocusable(false);
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MODEXPaint.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Assemble");
        this.jButton2.setFocusable(false);
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MODEXPaint.this.jButton2ActionPerformed(evt);
            }
        });
        this.bright.setMaximum(180);
        this.bright.setMinimum(20);
        this.bright.setMinorTickSpacing(20);
        this.bright.setPaintTicks(true);
        this.bright.setValue(100);
        this.bright.setFocusable(false);
        this.bright.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MODEXPaint.this.brightStateChanged(evt);
            }
        });
        this.contrast.setMaximum(180);
        this.contrast.setMinimum(20);
        this.contrast.setMinorTickSpacing(20);
        this.contrast.setPaintTicks(true);
        this.contrast.setValue(100);
        this.contrast.setFocusable(false);
        this.contrast.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MODEXPaint.this.contrastStateChanged(evt);
            }
        });
        this.gain.setMaximum(195);
        this.gain.setMinimum(105);
        this.gain.setMinorTickSpacing(15);
        this.gain.setPaintTicks(true);
        this.gain.setValue(150);
        this.gain.setFocusable(false);
        this.gain.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MODEXPaint.this.gainStateChanged(evt);
            }
        });
        this.jLabel3.setText("Gain:");
        this.jLabel2.setText("Contrast:");
        this.jLabel4.setText("Bright");
        this.alternative.setText("Dither");
        this.alternative.setFocusable(false);
        this.alternative.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MODEXPaint.this.alternativeActionPerformed(evt);
            }
        });
        this.jCheckBox1.setText("Overscan");
        this.jCheckBox1.setFocusable(false);
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MODEXPaint.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.free);
        this.free.setText("Free palette");
        this.free.setFocusable(false);
        this.free.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MODEXPaint.this.freeActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.partial);
        this.partial.setText("Partial palette");
        this.partial.setFocusable(false);
        this.partial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MODEXPaint.this.partialActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.full);
        this.full.setText("Preset palette");
        this.full.setFocusable(false);
        this.full.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MODEXPaint.this.fullActionPerformed(evt);
            }
        });
        this.jButton3.setText("Reset");
        this.jButton3.setFocusable(false);
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MODEXPaint.this.jButton3ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.stabilize);
        this.stabilize.setSelected(true);
        this.stabilize.setText("Stabilized palette");
        this.stabilize.setFocusable(false);
        this.stabilize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MODEXPaint.this.stabilizeActionPerformed(evt);
            }
        });
        this.direction.setText("Swap");
        this.direction.setFocusable(false);
        this.direction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MODEXPaint.this.directionActionPerformed(evt);
            }
        });
        this.preselect.setModel(new DefaultComboBoxModel<String>(new String[]{"Preset 1", "Preset 2", "Preset 3", "Preset 4", "Preset 5", "Preset 6"}));
        this.preselect.setFocusable(false);
        this.preselect.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MODEXPaint.this.preselectItemStateChanged(evt);
            }
        });
        this.rendermode.setText("R");
        this.rendermode.setFocusable(false);
        this.rendermode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MODEXPaint.this.rendermodeActionPerformed(evt);
            }
        });
        this.jLabel8.setText("DSK file:");
        this.diskname.setEditable(false);
        this.jButton6.setText("Create");
        this.jButton6.setFocusable(false);
        this.jButton6.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MODEXPaint.this.jButton6ActionPerformed(evt);
            }
        });
        this.jButton8.setText("Open");
        this.jButton8.setFocusable(false);
        this.jButton8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MODEXPaint.this.jButton8ActionPerformed(evt);
            }
        });
        this.jScrollPane4.setMinimumSize(new Dimension(25, 164));
        this.jList1.setFont(new Font("Monospaced", 0, 13));
        this.jList1.setModel((ListModel<String>)new AbstractListModel<String>(){
            String[] strings = new String[]{"no disk"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane4.setViewportView(this.jList1);
        this.jLabel9.setText("DIR:");
        this.jLabel10.setText("Filename:");
        this.rasname.setColumns(12);
        this.rasname.setText("SCREEN1");
        this.jButton7.setText("Write");
        this.jButton7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MODEXPaint.this.jButton7ActionPerformed(evt);
            }
        });
        this.free1.setText("0K");
        this.jLabel11.setText("Free:");
        this.buttonGroup1.add(this.c7d0);
        this.c7d0.setText("C7D0 Palette");
        this.c7d0.setFocusable(false);
        this.c7d0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MODEXPaint.this.c7d0ActionPerformed(evt);
            }
        });
        this.jButton4.setText("Copy");
        this.jButton4.setFocusable(false);
        this.jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MODEXPaint.this.jButton4ActionPerformed(evt);
            }
        });
        this.jButton5.setText("Get A");
        this.jButton5.setFocusable(false);
        this.jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MODEXPaint.this.jButton5ActionPerformed(evt);
            }
        });
        this.jButton9.setText("Get B");
        this.jButton9.setFocusable(false);
        this.jButton9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MODEXPaint.this.jButton9ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButton6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton8).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.diskname))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.free1)).addComponent(this.rasname, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton7)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane4, -2, 193, -2))).addGap(0, 6, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.alternative).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.free).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stabilize).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.partial)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bright, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.contrast, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.gain, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.direction).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rendermode))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.full).addComponent(this.preselect, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.c7d0).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton9).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -2, -1, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.diskname, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton6).addComponent(this.jButton8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel9).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane4, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.rasname, -2, -1, -2).addComponent(this.jButton7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.free1)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2).addComponent(this.alternative).addComponent(this.jCheckBox1).addComponent(this.free).addComponent(this.partial).addComponent(this.full).addComponent(this.stabilize).addComponent(this.c7d0).addComponent(this.jButton4).addComponent(this.jButton5).addComponent(this.jButton9)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4)).addGap(6, 6, 6)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bright, GroupLayout.Alignment.TRAILING, -2, 20, -2).addComponent(this.contrast, GroupLayout.Alignment.TRAILING, -2, 20, -2))).addComponent(this.gain, GroupLayout.Alignment.TRAILING, -2, 20, -2)).addComponent(this.jButton3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.direction).addComponent(this.preselect, -2, -1, -2).addComponent(this.rendermode))).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    public void importImage() {
        this.dialog.setVisible(true);
        String a = this.dialog.getFile();
        if (a != null && (a.toLowerCase().endsWith(".png") || a.toLowerCase().endsWith(".gif") || a.toLowerCase().endsWith(".bmp") || a.toLowerCase().endsWith(".jpg") || a.toLowerCase().endsWith(".jpeg"))) {
            this.importImage(this.dialog.getDirectory(), this.dialog.getFile());
        }
    }

    public void Render() {
        Color buff2;
        Color buff1;
        int val;
        int c;
        int x;
        int y;
        this.FormattedSource = new BufferedImage(this.imgwidth, this.imgheight, 1);
        this.FormattedSource.createGraphics().drawImage(this.Source, 0, 0, this.imgwidth, this.imgheight, this);
        if (!this.alternative.isSelected()) {
            for (int x2 = 0; x2 < this.imgwidth; ++x2) {
                for (int y2 = 0; y2 < this.imgheight; ++y2) {
                    int pix = this.FormattedSource.getRGB(x2, y2);
                    Color buff = new Color(pix);
                    int r = buff.getRed();
                    int g = buff.getGreen();
                    int b = buff.getBlue();
                    r = r > 200 ? 255 : (r > 40 ? 99 : 0);
                    g = g > 200 ? 255 : (g > 40 ? 99 : 0);
                    b = b > 200 ? 255 : (b > 40 ? 99 : 0);
                    buff = new Color(r, g, b);
                    this.FormattedSource.setRGB(x2, y2, buff.getRGB());
                }
            }
        }
        this.imageA = new BufferedImage(this.imgwidth, this.imgheight, 1);
        this.imageA.createGraphics().drawImage(this.FormattedSource, 0, 0, this.imgwidth, this.imgheight, this);
        this.imageB = new BufferedImage(this.imgwidth >> 1, this.imgheight, 1);
        this.imageB.createGraphics().drawImage(this.FormattedSource, 0, 0, this.imgwidth >> 1, this.imgheight, this);
        PaintCanvas.ditherval = this.alternative.isSelected() ? 30 : 290;
        this.can.buildCPCScreen(this.imageA, GateArray.inkTranslateColor, false);
        this.can.buildCPCScreen(this.imageB, GateArray.inkTranslateColor, false);
        BufferedImage bum = new BufferedImage(this.imgwidth >> 1, this.imgheight, 1);
        bum.createGraphics().drawImage(this.imageB, 0, 0, this.imgwidth >> 1, this.imgheight, this);
        this.imageB = new BufferedImage(this.imgwidth, this.imgheight, 1);
        this.imageB.createGraphics().drawImage(bum, 0, 0, this.imgwidth, this.imgheight, this);
        BufferedImage A = new BufferedImage(this.imgwidth, this.imgheight, 1);
        BufferedImage B = new BufferedImage(this.imgwidth, this.imgheight, 1);
        A.createGraphics().drawImage(this.imageA, 0, 0, this.imgwidth, this.imgheight, this);
        B.createGraphics().drawImage(this.imageB, 0, 0, this.imgwidth, this.imgheight, this);
        this.imageA = new BufferedImage(this.imgwidth, this.imgheight, 1);
        this.imageB = new BufferedImage(this.imgwidth, this.imgheight, 1);
        this.imageA.createGraphics().drawImage(A, 0, 0, this.imgwidth, this.imgheight, this);
        this.imageB.createGraphics().drawImage(B, 0, 0, this.imgwidth, this.imgheight, this);
        PaintCanvas.ditherval = 360;
        int[] palB = new int[16];
        System.arraycopy(this.Calculate(this.imageB, 16, true), 0, palB, 0, 16);
        int[] palA = new int[4];
        System.arraycopy(this.Calculate(this.imageA, 4, false), 0, palA, 0, 4);
        BufferedImage mod0 = new BufferedImage(this.imgwidth >> 1, this.imgheight, 1);
        mod0.createGraphics().drawImage(this.imageB, 0, 0, this.imgwidth >> 1, this.imgheight, this);
        BufferedImage pseudoImage = new BufferedImage(this.imgwidth, this.imgheight, 1);
        BufferedImage pseudoImageB = new BufferedImage(this.imgwidth << 1, this.imgheight << 1, 1);
        Graphics2D g = pseudoImage.createGraphics();
        g.drawImage((Image)this.imageA, 0, 0, this);
        for (y = 0; y < this.imgheight; ++y) {
            if (y % 2 == 1) {
                for (x = 0; x < this.imgwidth; ++x) {
                    pseudoImage.setRGB(x, y, this.imageA.getRGB(x, y));
                }
                continue;
            }
            for (x = 0; x < this.imgwidth; ++x) {
                pseudoImage.setRGB(x, y, this.imageB.getRGB(x, y));
            }
        }
        g = pseudoImageB.createGraphics();
        g.drawImage(pseudoImage, 0, 0, this.imgwidth << 1, this.imgheight << 1, this);
        this.jLabel1.setIcon(new ImageIcon(pseudoImageB));
        for (y = 0; y < this.imgheight; y += 2) {
            for (x = 0; x < this.imgwidth; x += 2) {
                for (c = 0; c < 16; ++c) {
                    val = pseudoImageB.getRGB(x << 1, y << 1);
                    buff1 = new Color(val);
                    buff2 = new Color(palB[c]);
                    if (buff1.getRed() != buff2.getRed() || buff1.getGreen() != buff2.getGreen() || buff1.getBlue() != buff2.getBlue()) continue;
                    CPC.PLOT(x >> 1, y, c, 0, this.overscan);
                }
            }
        }
        for (y = 1; y < this.imgheight; y += 2) {
            for (x = 0; x < this.imgwidth; ++x) {
                for (c = 0; c < 4; ++c) {
                    val = pseudoImageB.getRGB(x << 1, y << 1);
                    buff1 = new Color(val);
                    buff2 = new Color(palA[c]);
                    if (buff1.getRGB() != buff2.getRGB()) continue;
                    CPC.PLOT(x, y, c, 1, this.overscan);
                }
            }
        }
        if (this.overscan) {
            this.PaletteAddress = 2049;
            CPC.POKE(2048, 0);
        } else {
            this.PaletteAddress = 55249;
            CPC.POKE(55248, 0);
        }
        for (int i = 0; i < 16; ++i) {
            CPC.POKE(this.PaletteAddress + i, GateArray.getInk(i));
        }
    }

    void copyPalette() {
        int v = 0;
        for (int t = 55249; t < 55265; ++t) {
            this.presets[6][v++] = CPC.PEEK(t);
        }
        System.arraycopy(this.pimperial, 0, this.newPalette, 0, 16);
        System.arraycopy(this.presets[6], 0, this.newInks, 0, 16);
        for (int i = 0; i < 16; ++i) {
            GateArray.setInk(i, GateArray.Inks[this.newInks[i]]);
            this.GAPalette[i] = GateArray.Inks[this.newInks[i]] + 64;
        }
    }

    protected int[] Calculate(BufferedImage in, int cols, boolean calc) {
        if (calc) {
            int i;
            for (int i2 = 0; i2 < 32; ++i2) {
                this.palette[i2] = -1;
            }
            int width = in.getWidth();
            int height = in.getHeight();
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    for (int c = 0; c < GateArray.inkTranslateColor.length; ++c) {
                        if ((c == 0 || c == 27 || c == 3 || c == 9 || c == 20 || c == 12) && this.partial.isSelected() && this.full.isSelected() && this.c7d0.isSelected()) continue;
                        int col = in.getRGB(x, y);
                        Color buff1 = new Color(col);
                        Color buff2 = new Color(GateArray.inkTranslateColor[c]);
                        if (buff1.getRed() != buff2.getRed() || buff1.getGreen() != buff2.getGreen() || buff1.getBlue() != buff2.getBlue()) continue;
                        int n = c;
                        this.palette[n] = this.palette[n] + 1;
                    }
                }
            }
            for (int k = 0; k < cols; ++k) {
                int off = 0;
                int p = -1;
                for (int c = 0; c < 32; ++c) {
                    if (p >= this.palette[c]) continue;
                    p = this.palette[c];
                    off = c;
                }
                this.palette[off] = -1;
                this.newInks[k] = GateArray.GAInks[off];
                this.newPalette[k] = GateArray.inkTranslateColor[off];
            }
            for (i = 0; i < this.pimperial.length; ++i) {
                this.pimperial[i] = this.c7d0.isSelected() ? GateArray.inkTranslateColor[GateArray.Inks[this.presets[6][i]]] : GateArray.inkTranslateColor[GateArray.Inks[this.presets[this.preselect.getSelectedIndex()][i]]];
            }
            if (this.stabilize.isSelected()) {
                int i3;
                int feed = 0;
                if (this.direction.isSelected()) {
                    for (i3 = cols - 1; i3 >= 0; --i3) {
                        if (this.newInks[i3] != 0 && this.newInks[i3] != 12 && this.newInks[i3] != 13 && this.newInks[i3] != 15 && this.newInks[i3] != 16 && this.newInks[i3] != 18 && this.newInks[i3] != 26 && this.newInks[i3] != 25 || feed >= 4) continue;
                        int d = this.newInks[feed];
                        int v = this.newPalette[feed];
                        this.newInks[feed] = this.newInks[i3];
                        this.newPalette[feed++] = this.newPalette[i3];
                        this.newInks[i3] = d;
                        this.newPalette[i3] = v;
                    }
                } else {
                    for (i3 = 0; i3 < cols; ++i3) {
                        if (this.newInks[i3] != 0 && this.newInks[i3] != 12 && this.newInks[i3] != 13 && this.newInks[i3] != 15 && this.newInks[i3] != 16 && this.newInks[i3] != 18 && this.newInks[i3] != 26 && this.newInks[i3] != 25 || feed >= 4) continue;
                        int d = this.newInks[feed];
                        int v = this.newPalette[feed];
                        this.newInks[feed] = this.newInks[i3];
                        this.newPalette[feed++] = this.newPalette[i3];
                        this.newInks[i3] = d;
                        this.newPalette[i3] = v;
                    }
                }
                feed = 0;
                for (i3 = 1; i3 < cols; ++i3) {
                    if (this.newInks[i3] != 0 || feed >= 4) continue;
                    int d = this.newInks[feed];
                    int v = this.newPalette[feed];
                    this.newInks[feed] = this.newInks[i3];
                    this.newPalette[feed++] = this.newPalette[i3];
                    this.newInks[i3] = d;
                    this.newPalette[i3] = v;
                }
            }
            if (this.partial.isSelected() || this.full.isSelected() || this.c7d0.isSelected()) {
                if (this.c7d0.isSelected()) {
                    System.arraycopy(this.pimperial, 0, this.newPalette, 0, 16);
                    System.arraycopy(this.presets[6], 0, this.newInks, 0, 16);
                } else {
                    System.arraycopy(this.pimperial, 0, this.newPalette, 0, this.full.isSelected() ? cols : 4);
                    System.arraycopy(this.presets[this.preselect.getSelectedIndex()], 0, this.newInks, 0, this.full.isSelected() ? cols : 4);
                }
            }
            for (i = 0; i < cols; ++i) {
                GateArray.setInk(i, GateArray.Inks[this.newInks[i]]);
                this.GAPalette[i] = GateArray.Inks[this.newInks[i]] + 64;
            }
            System.out.println();
            GateArray.setInk(16, GateArray.Inks[this.newInks[0]]);
            System.arraycopy(this.newPalette, 0, this.mode1Palette, 0, 4);
        }
        if (calc) {
            this.can.buildCPCScreen(in, this.newPalette, false);
        } else {
            this.can.buildCPCScreen(in, this.mode1Palette, false);
        }
        return this.newPalette;
    }

    public void Render(BufferedImage Source2) {
        if (Source2 == null) {
            return;
        }
        this.Source = new BufferedImage(Source2.getWidth(), Source2.getHeight(), 1);
        this.Source.createGraphics().drawImage((Image)Source2, 0, 0, this);
        this.contrastfilter.setBrightness(this.Gain[this.bright.getValue()] + 1.0f);
        this.contrastfilter.setContrast(this.Gain[this.contrast.getValue()] + 1.0f);
        this.gainfilter.setGain(this.Gain[this.gain.getValue()]);
        this.contrastfilter.filter(this.Source, this.Source);
        this.gainfilter.filter(this.Source, this.Source);
        this.Render();
    }

    public void importImage(String path, String file) {
        this.fpath = path;
        this.ffile = file;
        File a = new File(path + file);
        try {
            this.buffer = ImageIO.read(a);
            BufferedImage r = new BufferedImage(this.imgwidth, this.imgheight, this.rendermode.isSelected() ? 13 : 1);
            r.createGraphics().drawImage(this.buffer, 0, 0, this.imgwidth, this.imgheight, this);
            this.buffer = new BufferedImage(this.imgwidth, this.imgheight, 1);
            this.buffer.createGraphics().drawImage((Image)r, 0, 0, this);
            this.Render(this.buffer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.assemble();
    }

    void assemble() {
        Thread sleeper = new Thread(){

            @Override
            public void run() {
                GateArray.cpc.reset();
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                MODEXPaint.this.code = MODEXPaint.this.overscan ? MODEXPaint.this.handler.makeHeader(GateArray.cpc.loadInternal("MODEXO.BIN", 34304, 624, 34304, 192), 34304, 624, 34304, "MODEXO") : MODEXPaint.this.handler.makeHeader(GateArray.cpc.loadInternal("MODEXN.BIN", 34304, 1865, 34304, 192), 34304, 624, 34304, "MODEXN");
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                MODEXPaint.this.Render(MODEXPaint.this.buffer);
            }
        };
        sleeper.start();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.dialog == null) {
            this.dialog = new FileDialog((Frame)this, "Import image", 0);
        }
        this.importImage();
    }

    private void brightStateChanged(ChangeEvent evt) {
        this.Render(this.buffer);
    }

    private void contrastStateChanged(ChangeEvent evt) {
        this.Render(this.buffer);
    }

    private void gainStateChanged(ChangeEvent evt) {
        this.Render(this.buffer);
    }

    private void alternativeActionPerformed(ActionEvent evt) {
        this.Render(this.buffer);
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.overscan = this.jCheckBox1.isSelected();
        if (this.overscan) {
            this.imgwidth = 384;
            this.imgheight = 272;
        } else {
            this.imgwidth = 320;
            this.imgheight = 200;
        }
        this.assemble();
    }

    private void freeActionPerformed(ActionEvent evt) {
        this.Render(this.buffer);
    }

    private void partialActionPerformed(ActionEvent evt) {
        this.Render(this.buffer);
    }

    private void fullActionPerformed(ActionEvent evt) {
        this.Render(this.buffer);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.gain.setValue(150);
        this.bright.setValue(100);
        this.contrast.setValue(100);
        this.Render(this.buffer);
    }

    private void stabilizeActionPerformed(ActionEvent evt) {
        this.Render(this.buffer);
    }

    private void directionActionPerformed(ActionEvent evt) {
        this.Render(this.buffer);
    }

    private void preselectItemStateChanged(ItemEvent evt) {
        this.Render(this.buffer);
    }

    private void rendermodeActionPerformed(ActionEvent evt) {
        this.importImage(this.fpath, this.ffile);
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        this.createDSK();
    }

    private void jButton8ActionPerformed(ActionEvent evt) {
        this.openDSK();
    }

    private void jButton7ActionPerformed(ActionEvent evt) {
        this.writeToDsk();
    }

    private void c7d0ActionPerformed(ActionEvent evt) {
        this.Render(this.buffer);
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.copyPalette();
    }

    public void putFlipA() {
        System.arraycopy(PaintCanvas.flipscreenA, 0, GateArray.screenmemory, 49152, 16384);
    }

    public void putFlipB() {
        System.arraycopy(PaintCanvas.flipscreenB, 0, GateArray.screenmemory, 49152, 16384);
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        this.putFlipA();
    }

    private void jButton9ActionPerformed(ActionEvent evt) {
        this.putFlipB();
    }

    public void createDSK() {
        if (this.create == null) {
            this.create = new FileDialog((Frame)this, "Save DSK File", 1);
        }
        this.create.setVisible(true);
        if (this.create.getFile() != null) {
            this.createDSK(this.create.getDirectory(), this.create.getFile());
        }
    }

    public void openDSK() {
        if (this.open == null) {
            this.open = new FileDialog((Frame)this, "Open DSK File", 0);
        }
        this.open.setVisible(true);
        if (this.open.getFile() != null) {
            this.openDSK(this.open.getDirectory(), this.open.getFile());
            Settings.set("rasterpath", this.open.getDirectory());
            Settings.set("rasterfile", this.open.getFile());
        }
    }

    public void createDSK(String path, String file) {
        if (this.system == null) {
            this.system = new CPCFileSystem();
        }
        byte[] dsk = this.system.getEmptyDSK();
        try {
            if (!file.toLowerCase().endsWith(".dsk")) {
                file = file + ".dsk";
            }
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(new File(path + file)));
            bos.write(dsk);
            bos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.diskname.setText(path + file);
        this.setModel();
        this.free1.setText(this.system.getDataSpace() + 6 + "K");
    }

    public void openDSK(String path, String file) {
        if (this.system == null) {
            this.system = new CPCFileSystem();
        }
        try {
            File a = new File(path + file);
            int size = (int)a.length();
            if (size != 204544) {
                this.diskname.setText("Bad disk format, please create a new DSK");
                return;
            }
            this.system.buffer = new byte[(int)a.length()];
            BufferedInputStream bos = new BufferedInputStream(new FileInputStream(new File(path + file)));
            bos.read(this.system.buffer);
            bos.close();
        }
        catch (Exception e) {
            return;
        }
        this.diskname.setText(path + file);
        this.setModel();
        this.free1.setText(this.system.getDataSpace() + 6 + "K");
    }

    public void setModel() {
        String[] array = this.system.DIR();
        final String[] strings = new HashSet<String>(Arrays.asList(array)).toArray(new String[0]);
        this.jList1.setModel((ListModel<String>)new AbstractListModel<String>(){

            @Override
            public int getSize() {
                return strings.length;
            }

            @Override
            public String getElementAt(int i) {
                return strings[i];
            }
        });
    }

    public void writeToDsk() {
        BufferedOutputStream bos2;
        String disk;
        if (this.system == null) {
            this.system = new CPCFileSystem();
        }
        if ((disk = this.diskname.getText()) == null || disk.length() < 1) {
            disk = "MODEX.dsk";
            File a = new File(disk);
            int count = 1;
            while (a.exists()) {
                disk = "MODEX_" + count + ".dsk";
                a = new File(disk);
                ++count;
            }
            this.diskname.setText(disk);
            byte[] dsk = this.system.getEmptyDSK();
            try {
                bos2 = new BufferedOutputStream(new FileOutputStream(a));
                bos2.write(dsk);
                bos2.close();
            }
            catch (Exception bos2) {
                // empty catch block
            }
        }
        this.system.DIR();
        String rasfile = this.rasname.getText();
        while (rasfile.contains(".")) {
            rasfile = rasfile.substring(0, rasfile.length() - 1);
        }
        while (rasfile.length() > 8) {
            rasfile = rasfile.substring(0, rasfile.length() - 1);
        }
        rasfile = this.overscan ? rasfile + ".MXO" : rasfile + ".MXN";
        this.rasname.setText(rasfile.toUpperCase());
        this.save("", rasfile);
        this.system.copyToDSK("", rasfile, disk);
        this.system.DIR();
        if (this.overscan) {
            this.system.Delete("MODEXO  .BIN");
            this.system.DIR();
            this.system.copyToDSK("", "MODEXO.BIN", disk);
            this.system.DIR();
        } else {
            this.system.Delete("MODEXN  .BIN");
            this.system.DIR();
            this.system.copyToDSK("", "MODEXN.BIN", disk);
            this.system.DIR();
        }
        String basic = this.generateBasic();
        File a = new File("DISC.BAS");
        if (this.overscan) {
            a = new File("DISCO.BAS");
            this.system.Delete("DISCO   .BAS");
            this.system.DIR();
        } else {
            this.system.Delete("DISC    .BAS");
            this.system.DIR();
        }
        try {
            bos2 = new BufferedOutputStream(new FileOutputStream(a));
            bos2.write(basic.getBytes("UTF-8"));
            bos2.close();
            this.system.copyToDSK("", "DISC" + (this.overscan ? "O" : "") + ".BAS", disk);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setModel();
        this.free1.setText(this.system.getDataSpace() + "K");
        if (a.exists()) {
            a.delete();
        }
        if ((a = new File(rasfile)).exists()) {
            a.delete();
        }
        if ((a = new File("MODEXN.BIN")).exists()) {
            a.delete();
        }
        if ((a = new File("MODEXO.BIN")).exists()) {
            a.delete();
        }
        try {
            GateArray.cpc.DSK_Load("buffer", this.system.buffer);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String generateBasic() {
        try {
            String bascode = this.overscan ? "10 OPENOUT\"D\":MEMORY &1FF:LOAD\"MODEXO.BIN\"\r\n" : "10 MODE 1:INK 0,0:BORDER 0:MEMORY &1FFF:LOAD\"MODEXN.BIN\"\r\n";
            String files = "";
            int forLoop = 0;
            String[] strings = this.system.DIR();
            for (int i = 0; i < strings.length; ++i) {
                if (strings[i] == null) continue;
                String entry = strings[i].toUpperCase();
                entry = entry.replace(" ", "");
                if (files.toUpperCase().contains(entry) || (!this.overscan || entry.toUpperCase().contains(".MXN")) && (this.overscan || entry.toUpperCase().contains(".MXO")) || entry.toUpperCase().contains("MODEXO.BIN") || entry.toUpperCase().contains("MODEXN.BIN") || entry.toUpperCase().contains("DISC.BAS") || entry.toUpperCase().contains("DISCO.BAS")) continue;
                files = files + entry + ",";
                ++forLoop;
            }
            files = files.substring(0, files.length() - 1);
            files = "20 DATA " + files + "\r\n";
            bascode = bascode + files;
            bascode = bascode + "30 RESTORE 20:FOR T=1 TO " + forLoop + ": READ A$:LOAD A$:CALL &8600:NEXT\r\n";
            return bascode;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void save(String path, String file) {
        try {
            File a = new File(path + "MODEX" + (this.overscan ? "O" : "N") + ".BIN");
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(a));
            bos.write(this.code);
            bos.close();
            if (this.overscan) {
                byte[] screen = new byte[31936];
                for (int i = 0; i < 31936; ++i) {
                    screen[i] = (byte)CPC.PEEK(512 + i);
                }
                screen = this.handler.makeHeader(screen, 512, 31936, "SCREENOV");
                a = new File(path + file);
                bos = new BufferedOutputStream(new FileOutputStream(a));
                bos.write(screen);
                bos.close();
            } else {
                byte[] screen = new byte[16384];
                for (int i = 0; i < 16384; ++i) {
                    screen[i] = (byte)CPC.PEEK(49152 + i);
                }
                screen = this.handler.makeHeader(screen, 49152, 16384, "SCREEN");
                a = new File(path + file);
                bos = new BufferedOutputStream(new FileOutputStream(a));
                bos.write(screen);
                bos.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

